#version 150
#extension GL_EXT_gpu_shader4 : enable
///////////////////////////////////////////////////////////////////////////////////////////////////
// iStripper wrapper for Shadertoy conversions by @Calgon  //
///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Notes
//
// Idea was to create a standard wrapper around Shadertoy code that could be applied to any shader
// sourced from Shadertoy.
// Version number is 150 as standard but where later functions are found this is changed to 330

// Wrapper Follows....
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Declare the missing thingamies that aren't available on VGHD
uniform vec3  iChannelResolution[4];	// BUT WE NEED TO FILL THEM !
uniform float iChannelTime[4];

//#define iResolution u_WindowSize
#define iResolution vec3(u_WindowSize, 0)	// Because Shadertoy iResolution is a vec3
#define iFrame 0


//Slow the time functions down a little as standard
//#define iTime u_Elapsed * .5
float iTime;

#define iGlobalTime u_Elapsed * .5

// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy texture0..3 with texture 0..3 further down
uniform sampler2D texture0; //Random Surfaces
uniform sampler2D texture1; //Water
uniform sampler2D texture2; //Random Greys
uniform sampler2D texture3; //More surfaces

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

#define texture texture2D_Fract	// So whenever Shadertoy says "texture" we run it through this Macro
// Can we do the same for Cubemaps 

#define iChannel0 texture0
#define iChannel1 texture1
#define iChannel2 texture2
#define iChannel3 texture3

// Mouse Simulation from @TheEmu	
#define iMouse vec4(0.)
// Alternative Macro if iMouse is better moving
//#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)
// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
//#define MOUSE_POS vec2((0.25+sin(iTime*MOUSE_SPEED*2))*u_WindowSize/2.0)
//#define MOUSE_POS vec2((sin(iTime*1)*.5*u_WindowSize.x/2.0),1.0*u_WindowSize.y/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



vec4 iDate;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Uniforms to control timing of each shader
//uniform float cycle_time;
uniform float bgnum;
uniform float maxbgnum;
//uniform float alpha_off;
//uniform float alpha_on;
//uniform float alpha_always_on;
uniform float scene_duration;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Extract a pixel from texture1 to get the random number
float randNum = texture(texture2, vec2(0.0, 0.0)).r;
float seed_start = 3*randNum-1.5;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
///////////////////////////////////////////////////////////////////////////////////////////////////

// Sourced from https://www.shadertoy.com/view/tlVfWw

const float speed = 0.6;
const vec3 pink = vec3(1.0, 0.9, 0.9);
const vec3 red = vec3(1.0, 0.2, 0.1);
const vec3 petalA = vec3(1.0, 0.7, 0.8);
const vec3 petalB = vec3(0.7, 0.0, 0.0);
const vec3 green = vec3(0.1, 0.4, 0.1);

vec2 rotate(vec2 p, float a) {
    float s = sin(a);
    float c = cos(a);
    return p * mat2(c, -s, s, c);
}

// Heart shape from https://www.shadertoy.com/view/XdcyW8
float heart(vec2 p) {
    float k = 1.2 * p.y - sqrt(abs(p.x) + 0.3) + 0.7;
    return step(p.x * p.x + k * k, 1.0);
}

float leaf(vec2 p) {
    p.y = abs(p.y);
    p -= vec2(0.5, -0.5);
    return step(dot(p, p), 0.5);
}

void petal(inout vec3 color, vec2 p) {
    float grad = 1.0 - p.x;
    color = mix(color, mix(petalA, petalB, grad * grad), leaf(p));
}

void flower(inout vec3 color, vec2 p) {
    p -= vec2(0.3, -0.1);
    float stem = step(p.x, 0.1) * step(-1.7, p.x);
    color = mix(color, green, step(abs(p.y + 0.2 * sin(2.0 * p.x)), 0.1 * stem));
    petal(color, rotate(p, -0.5));
    petal(color, rotate(p, 0.5));
    petal(color, p);
    p -= vec2(-0.7, 0.17);
    color = mix(color, green, leaf(rotate(p, -1.1)));
    color = mix(color, green, leaf(rotate(p, 1.1)));
}

void heartLayer(inout vec3 color, vec2 p, float t) {
    p *= 2.0;
    float col = floor(p.x);
    p.x = fract(p.x);
    p.y += 0.5 * t * (mod(col + 0.5, 2.0) - 1.0);
    float row = floor(p.y);
    p.y = fract(p.y);
    p -= vec2(0.5) + 0.2 * sin(vec2(11.0, 17.0) * (row + col) + t);
    color = mix(color, pink, smoothstep(0.25, 0.0, length(p)));
    p = rotate(p, col + 5.0 * row + 4.0 * (mod(row + 0.5, 2.0) - 1.0) * t);
    color = mix(color, red, heart(10.0 * p));
}

void flowerLayer(inout vec3 color, vec2 p, float t) {
    p *= 2.0;
    float col = floor(p.x);
    p.x = fract(p.x);
    p.y += 0.5 * t * (mod(col + 0.5, 2.0) - 1.0);
    float row = floor(p.y);
    p.y = fract(p.y);
    p -= vec2(0.5) + 0.2 * sin(vec2(11.0, 17.0) * (row + col) + t);
    color = mix(color, pink, smoothstep(0.25, 0.0, length(p)));
    p = rotate(p, col + 5.0 * row + 4.0 * (mod(row + 0.5, 2.0) - 1.0) * t);
    flower(color, 10.0 * p);
}

void heartFrame(inout vec3 color, vec2 p, float t) {
    p.y = -abs(p.y);
    color = mix(color, pink, smoothstep(-0.5, -1.1, p.y));

    p *= 0.5;
    p.x = fract(p.x);
    color = mix(color, red, heart(15.0 * (p + vec2(-0.93, 0.43))));
    
    float smallHeart = step(p.x, 0.86);
    p *= 10.5;
    float wave = 4.5 + 0.3 * sin(6.283185 * floor(p.x) / 10.5 + 2.0 * t);
    p.x = fract(p.x);
    color = mix(color, red, heart(2.3 * (p + vec2(-0.5, wave))) * smallHeart);
}

float stemHeight(float x) {
    return 0.5 * cos(0.6 * x) + 0.1 * sin(3.0 * x) + 0.04 * cos(5.3 * x);
}

float growth(float x, float t) {
    float center = t + 0.4 * (iResolution.x / iResolution.y) * sin(0.3 * t) - 0.5;
    return 1.0 - abs(center - x);
}

void bloom(inout vec3 color, vec2 p, float t) {
    p += vec2(t, 0.0);
    float center = t + sin(0.3 * t);
    float stem = clamp(2.0 * growth(p.x, t), 0.0, 1.0);
    color = mix(color, green, step(abs(p.y - stemHeight(p.x)), 0.006 * stem));
    
    float id = floor(p.x * 10.0 + 0.2) / 10.0;
    vec2 base = p - vec2(id, stemHeight(id));
    float g = smoothstep(0.0, 0.5, growth(id, t)) + 0.01;
    float size = (10.0 + 4.0 * sin(13.0 * id)) / g;
    color = mix(color, green, leaf(size * rotate(base, -1.1 * g)));
    size = (10.0 + 4.0 * sin(17.0 * id)) / g;
    color = mix(color, green, leaf(size * rotate(base, 1.1 * g)));
    
    id = floor(p.x * 3.0 + 0.4) / 3.0;
    base = p - vec2(id, stemHeight(id));
    g = growth(id, t);
    size = 5.0 / (smoothstep(0.0, 0.4, g) + 0.01);
    float dir = 1.5 * sin(10.0 * id);
    float r = smoothstep(0.0, 0.8, g);
    petal(color, size * rotate(base, dir - 0.9 * r));
    petal(color, size * rotate(base, dir + 0.9 * r));
    petal(color, size * rotate(base, dir - 0.5 * r));
    petal(color, size * rotate(base, dir + 0.5 * r));
    petal(color, size * rotate(base, dir));
}

void mainImage(out vec4 fragColor, in vec2 fragCoord) {
    vec2 pos = (2.0 * fragCoord - iResolution.xy) / iResolution.y;
    float time = speed * iTime;

    vec3 color = pink;
    
    heartLayer(color, rotate(3.0 * pos + vec2(time / 3.0, 0.0), 1.0), time + 10.0);
    color = mix(color, pink, 0.2);
    flowerLayer(color, rotate(2.5 * pos + vec2(time / 2.5, 0.0), 2.0), time + 20.0);
    color = mix(color, pink, 0.2);
    heartLayer(color, rotate(1.6 * pos + vec2(time / 1.6, 0.0), 2.0), time + 20.0);
    color = mix(color, pink, 0.2);
    flowerLayer(color, rotate(1.1 * pos + vec2(time / 1.1, 0.0), 3.0), time + 30.0);
    heartFrame(color, pos + vec2(time, 0.0), time);
    bloom(color, pos, time);

    fragColor = vec4(color, 1.0);
}


///////////////////////////////////////////////////////////////////////
// Shadertoy footer wrapper
///////////////////////////////////////////////////////////////////////

void main ( void )
{
	float alpha_on;
	float alpha_off;


	if (bgnum > 0){
		alpha_on  = scene_duration * (bgnum - 1.);
		alpha_off = scene_duration * (bgnum + 0.);
	}
	if (bgnum == 0){
		alpha_on  = scene_duration * (maxbgnum) - 1;
		alpha_off = scene_duration * (maxbgnum) + 1;
	}

	
	
	

	iTime = u_Elapsed * .5;


	if (iTime > 6000.){
		iTime = 6000. * fract(iTime / 6000.);
	}
	float cycle_time = maxbgnum * scene_duration;
	float cycles = (u_Elapsed)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	vec4 blank = vec4(0.);
	
	// Run the full program only at the right time..
	if ((part_cycles > alpha_on-1.)&&(part_cycles <= alpha_off+1.)){
		mainImage ( gl_FragColor, gl_FragCoord.xy );
		gl_FragColor.a = 1.0;
	}
	// Otherwise... just blank => massive performance boost
	else{
		gl_FragColor = blank;		
    }
	// Still need to fade it
	gl_FragColor.a = 0.0;
   if (part_cycles > alpha_on-1.){
	if (part_cycles <= alpha_off){
		gl_FragColor.a = 1.;
		if ((alpha_off - part_cycles)<1.){
			gl_FragColor.a = alpha_off - part_cycles;
		}
	}
   }
}


